package com.wissamfawaz;

public class SinglyLinkedList<T> implements SList<T> {
    private SNode<T> head, tail;
    private int size;

    public SinglyLinkedList() {
        head = tail = null;
        size = 0;
    }

    @Override
    public int size() {
        return size;
    }

    @Override
    public boolean isEmpty() {
        return size == 0;

    }

    @Override
    public void insertAtHead(T element) {
        SNode<T> newSNode = new SNode<>(element, head);

        if (isEmpty()) {
            tail = newSNode;
        }

        head = newSNode;
        size++;
    }

    @Override
    public void insertAtTail(T element) {
        SNode<T> newSNode = new SNode<>(element, null);

        if (isEmpty()) {
            head = newSNode;
        } else {
            tail.setNext(newSNode);
        }

        tail = newSNode;
        size++;
    }

    @Override
    public T removeFromHead() throws EmptyListException {
        T toReturn = getHead();

        if (head == tail) {
            head = tail = null;
        } else {
            SNode<T> temp = head;
            head = head.getNext();
            temp.setNext(null);
            temp = null;
        }

        size--;
        return toReturn;
    }

    @Override
    public T removeFromTail() throws EmptyListException {
        T toReturn = getTail();

        if (head == tail) {
            head = tail = null;
        } else {
            SNode<T> temp = head;
            while (temp.getNext() != tail) {
                temp = temp.getNext();
            }
            temp.setNext(null);
            tail = temp;
        }

        size--;
        return toReturn;
    }

    @Override
    public T getHead() throws EmptyListException {
        if (isEmpty()) {
            throw new EmptyListException("List is empty!");
        }
        return head.getElement();
    }

    @Override
    public T getTail() throws EmptyListException {
        if (isEmpty()) {
            throw new EmptyListException("List is empty!");
        }
        return tail.getElement();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();

        SNode<T> temp = head;
        while (temp != null) {
            sb.append(temp.getElement() + " ");
            temp = temp.getNext();
        }

        return sb.toString();
    }
}
